<!-- General JS Scripts -->
<script src="<?php echo e(asset('assets/modules/jquery/dist/jquery.min.js')); ?>"></script>
<script src="https://code.jquery.com/jquery-3.7.1.js" integrity="sha256-eKhayi8LEQwp4NKxN+CfCh+3qOVUtJn3QNZ0TciWLP4=" crossorigin="anonymous"></script>
<script src="<?php echo e(asset('assets/modules/popper.js/dist/popper.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/modules/bootstrap/dist/js/bootstrap.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/modules/jquery.nicescroll/dist/jquery.nicescroll.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/modules/moment/min/moment.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/dropzone.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/stisla.js')); ?>"></script>
<script src="https://www.gstatic.com/firebasejs/8.3.2/firebase-app.js"></script>
<script src="https://www.gstatic.com/firebasejs/8.3.2/firebase-messaging.js"></script>
<script src="https://www.gstatic.com/firebasejs/8.3.2/firebase.js"></script>
<!-- JS Libraries -->
<script src="<?php echo e(asset('assets/modules/izitoast/dist/js/iziToast.min.js')); ?>"></script>
<?php echo $__env->yieldContent('scripts'); ?>

<!-- Template JS File -->
<script src="<?php echo e(asset('assets/js/scripts.js')); ?>"></script>
<script src="<?php echo e(asset('js/custom.js')); ?>"></script>
<script type="text/javascript">
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });
    <?php if(session('success')): ?>
    iziToast.success({
        title: 'Success',
        message: '<?php echo e(session('success')); ?>',
        position: 'topRight'
    });
    <?php endif; ?>

    <?php if(session('error')): ?>
    iziToast.error({
        title: 'Error',
        message: '<?php echo e(session('error')); ?>',
        position: 'topRight'
    });
    <?php endif; ?>

</script>


<script type="text/javascript">
    $(document).ready(function() {
        const beep = document.getElementById("myAudio1");
        function sound() {
            beep.play();
        }
        const firebaseConfig = {
            apiKey: "<?php echo e(setting('firebase_api_key')); ?>",
            authDomain: "<?php echo e(setting('firebase_authDomain')); ?>",
            projectId: "<?php echo e(setting('projectId')); ?>",
            storageBucket: "<?php echo e(setting('storageBucket')); ?>",
            messagingSenderId: "<?php echo e(setting('messagingSenderId')); ?>",
            appId: "<?php echo e(setting('appId')); ?>",
            measurementId: "<?php echo e(setting('measurementId')); ?>",
        };
        firebase.initializeApp(firebaseConfig);
        const messaging = firebase.messaging();
        startFCM();
        function startFCM() {
            messaging.requestPermission()
                .then(function() {
                    return messaging.getToken()
                })
                .then(function(response) {
                    $.ajax({
                        url: '<?php echo e(route('store.token')); ?>',
                        type: 'POST',
                        data: {
                            token: response
                        },
                        dataType: 'JSON',
                        success: function(response) {
                        },
                        error: function(error) {
                        },
                    });

                }).catch(function(error) {});
        }

        messaging.onMessage(function(payload) {
            const title = payload.notification.title;
            const body = payload.notification.body;
            sound();
            $('#custom-width-modal').modal('show');
            $('#notificationTitle').text(title);
            $('#notificationBody').text(body);
            new Notification(title, {
                body: body,
            });
        });
    });
</script>

<script src="<?php echo e(asset('assets/js/comfirm-delete.js')); ?>"></script>





<?php /**PATH /Users/kawsaruddin/Workspace/8.2/foodbank/resources/views/admin/layouts/components/script.blade.php ENDPATH**/ ?>