/**!
 * @fileOverview Kickass library to create and place poppers near their reference elements.
 * @version 1.15.0
 * @license
 * Copyright (c) 2016 Federico Zivolo and contributors
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
 for(var isBrowser="undefined"!=typeof window&&"undefined"!=typeof document,longerTimeoutBrowsers=["Edge","Trident","Firefox"],timeoutDuration=0,i=0;i<longerTimeoutBrowsers.length;i+=1)if(isBrowser&&navigator.userAgent.indexOf(longerTimeoutBrowsers[i])>=0){timeoutDuration=1;break}function microtaskDebounce(e){var t=!1;return function(){t||(t=!0,window.Promise.resolve().then((function(){t=!1,e()})))}}function taskDebounce(e){var t=!1;return function(){t||(t=!0,setTimeout((function(){t=!1,e()}),timeoutDuration))}}var supportsMicroTasks=isBrowser&&window.Promise,debounce=supportsMicroTasks?microtaskDebounce:taskDebounce;function isFunction(e){return e&&"[object Function]"==={}.toString.call(e)}function getStyleComputedProperty(e,t){if(1!==e.nodeType)return[];var n=e.ownerDocument.defaultView.getComputedStyle(e,null);return t?n[t]:n}function getParentNode(e){return"HTML"===e.nodeName?e:e.parentNode||e.host}function getScrollParent(e){if(!e)return document.body;switch(e.nodeName){case"HTML":case"BODY":return e.ownerDocument.body;case"#document":return e.body}var t=getStyleComputedProperty(e),n=t.overflow,r=t.overflowX,o=t.overflowY;return/(auto|scroll|overlay)/.test(n+o+r)?e:getScrollParent(getParentNode(e))}var isIE11=isBrowser&&!(!window.MSInputMethodContext||!document.documentMode),isIE10=isBrowser&&/MSIE 10/.test(navigator.userAgent);function isIE(e){return 11===e?isIE11:10===e?isIE10:isIE11||isIE10}function getOffsetParent(e){if(!e)return document.documentElement;for(var t=isIE(10)?document.body:null,n=e.offsetParent||null;n===t&&e.nextElementSibling;)n=(e=e.nextElementSibling).offsetParent;var r=n&&n.nodeName;return r&&"BODY"!==r&&"HTML"!==r?-1!==["TH","TD","TABLE"].indexOf(n.nodeName)&&"static"===getStyleComputedProperty(n,"position")?getOffsetParent(n):n:e?e.ownerDocument.documentElement:document.documentElement}function isOffsetContainer(e){var t=e.nodeName;return"BODY"!==t&&("HTML"===t||getOffsetParent(e.firstElementChild)===e)}function getRoot(e){return null!==e.parentNode?getRoot(e.parentNode):e}function findCommonOffsetParent(e,t){if(!(e&&e.nodeType&&t&&t.nodeType))return document.documentElement;var n=e.compareDocumentPosition(t)&Node.DOCUMENT_POSITION_FOLLOWING,r=n?e:t,o=n?t:e,i=document.createRange();i.setStart(r,0),i.setEnd(o,0);var s=i.commonAncestorContainer;if(e!==s&&t!==s||r.contains(o))return isOffsetContainer(s)?s:getOffsetParent(s);var a=getRoot(e);return a.host?findCommonOffsetParent(a.host,t):findCommonOffsetParent(e,getRoot(t).host)}function getScroll(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:"top",n="top"===t?"scrollTop":"scrollLeft",r=e.nodeName;if("BODY"===r||"HTML"===r){var o=e.ownerDocument.documentElement,i=e.ownerDocument.scrollingElement||o;return i[n]}return e[n]}function includeScroll(e,t){var n=arguments.length>2&&void 0!==arguments[2]&&arguments[2],r=getScroll(t,"top"),o=getScroll(t,"left"),i=n?-1:1;return e.top+=r*i,e.bottom+=r*i,e.left+=o*i,e.right+=o*i,e}function getBordersSize(e,t){var n="x"===t?"Left":"Top",r="Left"===n?"Right":"Bottom";return parseFloat(e["border"+n+"Width"],10)+parseFloat(e["border"+r+"Width"],10)}function getSize(e,t,n,r){return Math.max(t["offset"+e],t["scroll"+e],n["client"+e],n["offset"+e],n["scroll"+e],isIE(10)?parseInt(n["offset"+e])+parseInt(r["margin"+("Height"===e?"Top":"Left")])+parseInt(r["margin"+("Height"===e?"Bottom":"Right")]):0)}function getWindowSizes(e){var t=e.body,n=e.documentElement,r=isIE(10)&&getComputedStyle(n);return{height:getSize("Height",t,n,r),width:getSize("Width",t,n,r)}}var classCallCheck=function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")},createClass=function(){function e(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}return function(t,n,r){return n&&e(t.prototype,n),r&&e(t,r),t}}(),defineProperty=function(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e},_extends=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var r in n)Object.prototype.hasOwnProperty.call(n,r)&&(e[r]=n[r])}return e};function getClientRect(e){return _extends({},e,{right:e.left+e.width,bottom:e.top+e.height})}function getBoundingClientRect(e){var t={};try{if(isIE(10)){t=e.getBoundingClientRect();var n=getScroll(e,"top"),r=getScroll(e,"left");t.top+=n,t.left+=r,t.bottom+=n,t.right+=r}else t=e.getBoundingClientRect()}catch(e){}var o={left:t.left,top:t.top,width:t.right-t.left,height:t.bottom-t.top},i="HTML"===e.nodeName?getWindowSizes(e.ownerDocument):{},s=i.width||e.clientWidth||o.right-o.left,a=i.height||e.clientHeight||o.bottom-o.top,f=e.offsetWidth-s,p=e.offsetHeight-a;if(f||p){var l=getStyleComputedProperty(e);f-=getBordersSize(l,"x"),p-=getBordersSize(l,"y"),o.width-=f,o.height-=p}return getClientRect(o)}function getOffsetRectRelativeToArbitraryNode(e,t){var n=arguments.length>2&&void 0!==arguments[2]&&arguments[2],r=isIE(10),o="HTML"===t.nodeName,i=getBoundingClientRect(e),s=getBoundingClientRect(t),a=getScrollParent(e),f=getStyleComputedProperty(t),p=parseFloat(f.borderTopWidth,10),l=parseFloat(f.borderLeftWidth,10);n&&o&&(s.top=Math.max(s.top,0),s.left=Math.max(s.left,0));var d=getClientRect({top:i.top-s.top-p,left:i.left-s.left-l,width:i.width,height:i.height});if(d.marginTop=0,d.marginLeft=0,!r&&o){var c=parseFloat(f.marginTop,10),u=parseFloat(f.marginLeft,10);d.top-=p-c,d.bottom-=p-c,d.left-=l-u,d.right-=l-u,d.marginTop=c,d.marginLeft=u}return(r&&!n?t.contains(a):t===a&&"BODY"!==a.nodeName)&&(d=includeScroll(d,t)),d}function getViewportOffsetRectRelativeToArtbitraryNode(e){var t=arguments.length>1&&void 0!==arguments[1]&&arguments[1],n=e.ownerDocument.documentElement,r=getOffsetRectRelativeToArbitraryNode(e,n),o=Math.max(n.clientWidth,window.innerWidth||0),i=Math.max(n.clientHeight,window.innerHeight||0),s=t?0:getScroll(n),a=t?0:getScroll(n,"left"),f={top:s-r.top+r.marginTop,left:a-r.left+r.marginLeft,width:o,height:i};return getClientRect(f)}function isFixed(e){var t=e.nodeName;if("BODY"===t||"HTML"===t)return!1;if("fixed"===getStyleComputedProperty(e,"position"))return!0;var n=getParentNode(e);return!!n&&isFixed(n)}function getFixedPositionOffsetParent(e){if(!e||!e.parentElement||isIE())return document.documentElement;for(var t=e.parentElement;t&&"none"===getStyleComputedProperty(t,"transform");)t=t.parentElement;return t||document.documentElement}function getBoundaries(e,t,n,r){var o=arguments.length>4&&void 0!==arguments[4]&&arguments[4],i={top:0,left:0},s=o?getFixedPositionOffsetParent(e):findCommonOffsetParent(e,t);if("viewport"===r)i=getViewportOffsetRectRelativeToArtbitraryNode(s,o);else{var a=void 0;"scrollParent"===r?"BODY"===(a=getScrollParent(getParentNode(t))).nodeName&&(a=e.ownerDocument.documentElement):a="window"===r?e.ownerDocument.documentElement:r;var f=getOffsetRectRelativeToArbitraryNode(a,s,o);if("HTML"!==a.nodeName||isFixed(s))i=f;else{var p=getWindowSizes(e.ownerDocument),l=p.height,d=p.width;i.top+=f.top-f.marginTop,i.bottom=l+f.top,i.left+=f.left-f.marginLeft,i.right=d+f.left}}var c="number"==typeof(n=n||0);return i.left+=c?n:n.left||0,i.top+=c?n:n.top||0,i.right-=c?n:n.right||0,i.bottom-=c?n:n.bottom||0,i}function getArea(e){return e.width*e.height}function computeAutoPlacement(e,t,n,r,o){var i=arguments.length>5&&void 0!==arguments[5]?arguments[5]:0;if(-1===e.indexOf("auto"))return e;var s=getBoundaries(n,r,i,o),a={top:{width:s.width,height:t.top-s.top},right:{width:s.right-t.right,height:s.height},bottom:{width:s.width,height:s.bottom-t.bottom},left:{width:t.left-s.left,height:s.height}},f=Object.keys(a).map((function(e){return _extends({key:e},a[e],{area:getArea(a[e])})})).sort((function(e,t){return t.area-e.area})),p=f.filter((function(e){var t=e.width,r=e.height;return t>=n.clientWidth&&r>=n.clientHeight})),l=p.length>0?p[0].key:f[0].key,d=e.split("-")[1];return l+(d?"-"+d:"")}function getReferenceOffsets(e,t,n){var r=arguments.length>3&&void 0!==arguments[3]?arguments[3]:null,o=r?getFixedPositionOffsetParent(t):findCommonOffsetParent(t,n);return getOffsetRectRelativeToArbitraryNode(n,o,r)}function getOuterSizes(e){var t=e.ownerDocument.defaultView.getComputedStyle(e),n=parseFloat(t.marginTop||0)+parseFloat(t.marginBottom||0),r=parseFloat(t.marginLeft||0)+parseFloat(t.marginRight||0);return{width:e.offsetWidth+r,height:e.offsetHeight+n}}function getOppositePlacement(e){var t={left:"right",right:"left",bottom:"top",top:"bottom"};return e.replace(/left|right|bottom|top/g,(function(e){return t[e]}))}function getPopperOffsets(e,t,n){n=n.split("-")[0];var r=getOuterSizes(e),o={width:r.width,height:r.height},i=-1!==["right","left"].indexOf(n),s=i?"top":"left",a=i?"left":"top",f=i?"height":"width",p=i?"width":"height";return o[s]=t[s]+t[f]/2-r[f]/2,o[a]=n===a?t[a]-r[p]:t[getOppositePlacement(a)],o}function find(e,t){return Array.prototype.find?e.find(t):e.filter(t)[0]}function findIndex(e,t,n){if(Array.prototype.findIndex)return e.findIndex((function(e){return e[t]===n}));var r=find(e,(function(e){return e[t]===n}));return e.indexOf(r)}function runModifiers(e,t,n){return(void 0===n?e:e.slice(0,findIndex(e,"name",n))).forEach((function(e){e.function&&console.warn("`modifier.function` is deprecated, use `modifier.fn`!");var n=e.function||e.fn;e.enabled&&isFunction(n)&&(t.offsets.popper=getClientRect(t.offsets.popper),t.offsets.reference=getClientRect(t.offsets.reference),t=n(t,e))})),t}function update(){if(!this.state.isDestroyed){var e={instance:this,styles:{},arrowStyles:{},attributes:{},flipped:!1,offsets:{}};e.offsets.reference=getReferenceOffsets(this.state,this.popper,this.reference,this.options.positionFixed),e.placement=computeAutoPlacement(this.options.placement,e.offsets.reference,this.popper,this.reference,this.options.modifiers.flip.boundariesElement,this.options.modifiers.flip.padding),e.originalPlacement=e.placement,e.positionFixed=this.options.positionFixed,e.offsets.popper=getPopperOffsets(this.popper,e.offsets.reference,e.placement),e.offsets.popper.position=this.options.positionFixed?"fixed":"absolute",e=runModifiers(this.modifiers,e),this.state.isCreated?this.options.onUpdate(e):(this.state.isCreated=!0,this.options.onCreate(e))}}function isModifierEnabled(e,t){return e.some((function(e){var n=e.name;return e.enabled&&n===t}))}function getSupportedPropertyName(e){for(var t=[!1,"ms","Webkit","Moz","O"],n=e.charAt(0).toUpperCase()+e.slice(1),r=0;r<t.length;r++){var o=t[r],i=o?""+o+n:e;if(void 0!==document.body.style[i])return i}return null}function destroy(){return this.state.isDestroyed=!0,isModifierEnabled(this.modifiers,"applyStyle")&&(this.popper.removeAttribute("x-placement"),this.popper.style.position="",this.popper.style.top="",this.popper.style.left="",this.popper.style.right="",this.popper.style.bottom="",this.popper.style.willChange="",this.popper.style[getSupportedPropertyName("transform")]=""),this.disableEventListeners(),this.options.removeOnDestroy&&this.popper.parentNode.removeChild(this.popper),this}function getWindow(e){var t=e.ownerDocument;return t?t.defaultView:window}function attachToScrollParents(e,t,n,r){var o="BODY"===e.nodeName,i=o?e.ownerDocument.defaultView:e;i.addEventListener(t,n,{passive:!0}),o||attachToScrollParents(getScrollParent(i.parentNode),t,n,r),r.push(i)}function setupEventListeners(e,t,n,r){n.updateBound=r,getWindow(e).addEventListener("resize",n.updateBound,{passive:!0});var o=getScrollParent(e);return attachToScrollParents(o,"scroll",n.updateBound,n.scrollParents),n.scrollElement=o,n.eventsEnabled=!0,n}function enableEventListeners(){this.state.eventsEnabled||(this.state=setupEventListeners(this.reference,this.options,this.state,this.scheduleUpdate))}function removeEventListeners(e,t){return getWindow(e).removeEventListener("resize",t.updateBound),t.scrollParents.forEach((function(e){e.removeEventListener("scroll",t.updateBound)})),t.updateBound=null,t.scrollParents=[],t.scrollElement=null,t.eventsEnabled=!1,t}function disableEventListeners(){this.state.eventsEnabled&&(cancelAnimationFrame(this.scheduleUpdate),this.state=removeEventListeners(this.reference,this.state))}function isNumeric(e){return""!==e&&!isNaN(parseFloat(e))&&isFinite(e)}function setStyles(e,t){Object.keys(t).forEach((function(n){var r="";-1!==["width","height","top","right","bottom","left"].indexOf(n)&&isNumeric(t[n])&&(r="px"),e.style[n]=t[n]+r}))}function setAttributes(e,t){Object.keys(t).forEach((function(n){!1!==t[n]?e.setAttribute(n,t[n]):e.removeAttribute(n)}))}function applyStyle(e){return setStyles(e.instance.popper,e.styles),setAttributes(e.instance.popper,e.attributes),e.arrowElement&&Object.keys(e.arrowStyles).length&&setStyles(e.arrowElement,e.arrowStyles),e}function applyStyleOnLoad(e,t,n,r,o){var i=getReferenceOffsets(o,t,e,n.positionFixed),s=computeAutoPlacement(n.placement,i,t,e,n.modifiers.flip.boundariesElement,n.modifiers.flip.padding);return t.setAttribute("x-placement",s),setStyles(t,{position:n.positionFixed?"fixed":"absolute"}),n}function getRoundedOffsets(e,t){var n=e.offsets,r=n.popper,o=n.reference,i=Math.round,s=Math.floor,a=function(e){return e},f=i(o.width),p=i(r.width),l=-1!==["left","right"].indexOf(e.placement),d=-1!==e.placement.indexOf("-"),c=t?l||d||f%2==p%2?i:s:a,u=t?i:a;return{left:c(f%2==1&&p%2==1&&!d&&t?r.left-1:r.left),top:u(r.top),bottom:u(r.bottom),right:c(r.right)}}var isFirefox=isBrowser&&/Firefox/i.test(navigator.userAgent);function computeStyle(e,t){var n=t.x,r=t.y,o=e.offsets.popper,i=find(e.instance.modifiers,(function(e){return"applyStyle"===e.name})).gpuAcceleration;void 0!==i&&console.warn("WARNING: `gpuAcceleration` option moved to `computeStyle` modifier and will not be supported in future versions of Popper.js!");var s=void 0!==i?i:t.gpuAcceleration,a=getOffsetParent(e.instance.popper),f=getBoundingClientRect(a),p={position:o.position},l=getRoundedOffsets(e,window.devicePixelRatio<2||!isFirefox),d="bottom"===n?"top":"bottom",c="right"===r?"left":"right",u=getSupportedPropertyName("transform"),m=void 0,h=void 0;if(h="bottom"===d?"HTML"===a.nodeName?-a.clientHeight+l.bottom:-f.height+l.bottom:l.top,m="right"===c?"HTML"===a.nodeName?-a.clientWidth+l.right:-f.width+l.right:l.left,s&&u)p[u]="translate3d("+m+"px, "+h+"px, 0)",p[d]=0,p[c]=0,p.willChange="transform";else{var g="bottom"===d?-1:1,v="right"===c?-1:1;p[d]=h*g,p[c]=m*v,p.willChange=d+", "+c}var b={"x-placement":e.placement};return e.attributes=_extends({},b,e.attributes),e.styles=_extends({},p,e.styles),e.arrowStyles=_extends({},e.offsets.arrow,e.arrowStyles),e}function isModifierRequired(e,t,n){var r=find(e,(function(e){return e.name===t})),o=!!r&&e.some((function(e){return e.name===n&&e.enabled&&e.order<r.order}));if(!o){var i="`"+t+"`",s="`"+n+"`";console.warn(s+" modifier is required by "+i+" modifier in order to work, be sure to include it before "+i+"!")}return o}function arrow(e,t){var n;if(!isModifierRequired(e.instance.modifiers,"arrow","keepTogether"))return e;var r=t.element;if("string"==typeof r){if(!(r=e.instance.popper.querySelector(r)))return e}else if(!e.instance.popper.contains(r))return console.warn("WARNING: `arrow.element` must be child of its popper element!"),e;var o=e.placement.split("-")[0],i=e.offsets,s=i.popper,a=i.reference,f=-1!==["left","right"].indexOf(o),p=f?"height":"width",l=f?"Top":"Left",d=l.toLowerCase(),c=f?"left":"top",u=f?"bottom":"right",m=getOuterSizes(r)[p];a[u]-m<s[d]&&(e.offsets.popper[d]-=s[d]-(a[u]-m)),a[d]+m>s[u]&&(e.offsets.popper[d]+=a[d]+m-s[u]),e.offsets.popper=getClientRect(e.offsets.popper);var h=a[d]+a[p]/2-m/2,g=getStyleComputedProperty(e.instance.popper),v=parseFloat(g["margin"+l],10),b=parseFloat(g["border"+l+"Width"],10),w=h-e.offsets.popper[d]-v-b;return w=Math.max(Math.min(s[p]-m,w),0),e.arrowElement=r,e.offsets.arrow=(defineProperty(n={},d,Math.round(w)),defineProperty(n,c,""),n),e}function getOppositeVariation(e){return"end"===e?"start":"start"===e?"end":e}var placements=["auto-start","auto","auto-end","top-start","top","top-end","right-start","right","right-end","bottom-end","bottom","bottom-start","left-end","left","left-start"],validPlacements=placements.slice(3);function clockwise(e){var t=arguments.length>1&&void 0!==arguments[1]&&arguments[1],n=validPlacements.indexOf(e),r=validPlacements.slice(n+1).concat(validPlacements.slice(0,n));return t?r.reverse():r}var BEHAVIORS={FLIP:"flip",CLOCKWISE:"clockwise",COUNTERCLOCKWISE:"counterclockwise"};function flip(e,t){if(isModifierEnabled(e.instance.modifiers,"inner"))return e;if(e.flipped&&e.placement===e.originalPlacement)return e;var n=getBoundaries(e.instance.popper,e.instance.reference,t.padding,t.boundariesElement,e.positionFixed),r=e.placement.split("-")[0],o=getOppositePlacement(r),i=e.placement.split("-")[1]||"",s=[];switch(t.behavior){case BEHAVIORS.FLIP:s=[r,o];break;case BEHAVIORS.CLOCKWISE:s=clockwise(r);break;case BEHAVIORS.COUNTERCLOCKWISE:s=clockwise(r,!0);break;default:s=t.behavior}return s.forEach((function(a,f){if(r!==a||s.length===f+1)return e;r=e.placement.split("-")[0],o=getOppositePlacement(r);var p=e.offsets.popper,l=e.offsets.reference,d=Math.floor,c="left"===r&&d(p.right)>d(l.left)||"right"===r&&d(p.left)<d(l.right)||"top"===r&&d(p.bottom)>d(l.top)||"bottom"===r&&d(p.top)<d(l.bottom),u=d(p.left)<d(n.left),m=d(p.right)>d(n.right),h=d(p.top)<d(n.top),g=d(p.bottom)>d(n.bottom),v="left"===r&&u||"right"===r&&m||"top"===r&&h||"bottom"===r&&g,b=-1!==["top","bottom"].indexOf(r),w=!!t.flipVariations&&(b&&"start"===i&&u||b&&"end"===i&&m||!b&&"start"===i&&h||!b&&"end"===i&&g),y=!!t.flipVariationsByContent&&(b&&"start"===i&&m||b&&"end"===i&&u||!b&&"start"===i&&g||!b&&"end"===i&&h),O=w||y;(c||v||O)&&(e.flipped=!0,(c||v)&&(r=s[f+1]),O&&(i=getOppositeVariation(i)),e.placement=r+(i?"-"+i:""),e.offsets.popper=_extends({},e.offsets.popper,getPopperOffsets(e.instance.popper,e.offsets.reference,e.placement)),e=runModifiers(e.instance.modifiers,e,"flip"))})),e}function keepTogether(e){var t=e.offsets,n=t.popper,r=t.reference,o=e.placement.split("-")[0],i=Math.floor,s=-1!==["top","bottom"].indexOf(o),a=s?"right":"bottom",f=s?"left":"top",p=s?"width":"height";return n[a]<i(r[f])&&(e.offsets.popper[f]=i(r[f])-n[p]),n[f]>i(r[a])&&(e.offsets.popper[f]=i(r[a])),e}function toValue(e,t,n,r){var o=e.match(/((?:\-|\+)?\d*\.?\d*)(.*)/),i=+o[1],s=o[2];if(!i)return e;if(0===s.indexOf("%")){var a=void 0;if("%p"===s)a=n;else a=r;return getClientRect(a)[t]/100*i}if("vh"===s||"vw"===s){return("vh"===s?Math.max(document.documentElement.clientHeight,window.innerHeight||0):Math.max(document.documentElement.clientWidth,window.innerWidth||0))/100*i}return i}function parseOffset(e,t,n,r){var o=[0,0],i=-1!==["right","left"].indexOf(r),s=e.split(/(\+|\-)/).map((function(e){return e.trim()})),a=s.indexOf(find(s,(function(e){return-1!==e.search(/,|\s/)})));s[a]&&-1===s[a].indexOf(",")&&console.warn("Offsets separated by white space(s) are deprecated, use a comma (,) instead.");var f=/\s*,\s*|\s+/,p=-1!==a?[s.slice(0,a).concat([s[a].split(f)[0]]),[s[a].split(f)[1]].concat(s.slice(a+1))]:[s];return(p=p.map((function(e,r){var o=(1===r?!i:i)?"height":"width",s=!1;return e.reduce((function(e,t){return""===e[e.length-1]&&-1!==["+","-"].indexOf(t)?(e[e.length-1]=t,s=!0,e):s?(e[e.length-1]+=t,s=!1,e):e.concat(t)}),[]).map((function(e){return toValue(e,o,t,n)}))}))).forEach((function(e,t){e.forEach((function(n,r){isNumeric(n)&&(o[t]+=n*("-"===e[r-1]?-1:1))}))})),o}function offset(e,t){var n=t.offset,r=e.placement,o=e.offsets,i=o.popper,s=o.reference,a=r.split("-")[0],f=void 0;return f=isNumeric(+n)?[+n,0]:parseOffset(n,i,s,a),"left"===a?(i.top+=f[0],i.left-=f[1]):"right"===a?(i.top+=f[0],i.left+=f[1]):"top"===a?(i.left+=f[0],i.top-=f[1]):"bottom"===a&&(i.left+=f[0],i.top+=f[1]),e.popper=i,e}function preventOverflow(e,t){var n=t.boundariesElement||getOffsetParent(e.instance.popper);e.instance.reference===n&&(n=getOffsetParent(n));var r=getSupportedPropertyName("transform"),o=e.instance.popper.style,i=o.top,s=o.left,a=o[r];o.top="",o.left="",o[r]="";var f=getBoundaries(e.instance.popper,e.instance.reference,t.padding,n,e.positionFixed);o.top=i,o.left=s,o[r]=a,t.boundaries=f;var p=t.priority,l=e.offsets.popper,d={primary:function(e){var n=l[e];return l[e]<f[e]&&!t.escapeWithReference&&(n=Math.max(l[e],f[e])),defineProperty({},e,n)},secondary:function(e){var n="right"===e?"left":"top",r=l[n];return l[e]>f[e]&&!t.escapeWithReference&&(r=Math.min(l[n],f[e]-("right"===e?l.width:l.height))),defineProperty({},n,r)}};return p.forEach((function(e){var t=-1!==["left","top"].indexOf(e)?"primary":"secondary";l=_extends({},l,d[t](e))})),e.offsets.popper=l,e}function shift(e){var t=e.placement,n=t.split("-")[0],r=t.split("-")[1];if(r){var o=e.offsets,i=o.reference,s=o.popper,a=-1!==["bottom","top"].indexOf(n),f=a?"left":"top",p=a?"width":"height",l={start:defineProperty({},f,i[f]),end:defineProperty({},f,i[f]+i[p]-s[p])};e.offsets.popper=_extends({},s,l[r])}return e}function hide(e){if(!isModifierRequired(e.instance.modifiers,"hide","preventOverflow"))return e;var t=e.offsets.reference,n=find(e.instance.modifiers,(function(e){return"preventOverflow"===e.name})).boundaries;if(t.bottom<n.top||t.left>n.right||t.top>n.bottom||t.right<n.left){if(!0===e.hide)return e;e.hide=!0,e.attributes["x-out-of-boundaries"]=""}else{if(!1===e.hide)return e;e.hide=!1,e.attributes["x-out-of-boundaries"]=!1}return e}function inner(e){var t=e.placement,n=t.split("-")[0],r=e.offsets,o=r.popper,i=r.reference,s=-1!==["left","right"].indexOf(n),a=-1===["top","left"].indexOf(n);return o[s?"left":"top"]=i[n]-(a?o[s?"width":"height"]:0),e.placement=getOppositePlacement(t),e.offsets.popper=getClientRect(o),e}var modifiers={shift:{order:100,enabled:!0,fn:shift},offset:{order:200,enabled:!0,fn:offset,offset:0},preventOverflow:{order:300,enabled:!0,fn:preventOverflow,priority:["left","right","top","bottom"],padding:5,boundariesElement:"scrollParent"},keepTogether:{order:400,enabled:!0,fn:keepTogether},arrow:{order:500,enabled:!0,fn:arrow,element:"[x-arrow]"},flip:{order:600,enabled:!0,fn:flip,behavior:"flip",padding:5,boundariesElement:"viewport",flipVariations:!1,flipVariationsByContent:!1},inner:{order:700,enabled:!1,fn:inner},hide:{order:800,enabled:!0,fn:hide},computeStyle:{order:850,enabled:!0,fn:computeStyle,gpuAcceleration:!0,x:"bottom",y:"right"},applyStyle:{order:900,enabled:!0,fn:applyStyle,onLoad:applyStyleOnLoad,gpuAcceleration:void 0}},Defaults={placement:"bottom",positionFixed:!1,eventsEnabled:!0,removeOnDestroy:!1,onCreate:function(){},onUpdate:function(){},modifiers:modifiers},Popper=function(){function e(t,n){var r=this,o=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};classCallCheck(this,e),this.scheduleUpdate=function(){return requestAnimationFrame(r.update)},this.update=debounce(this.update.bind(this)),this.options=_extends({},e.Defaults,o),this.state={isDestroyed:!1,isCreated:!1,scrollParents:[]},this.reference=t&&t.jquery?t[0]:t,this.popper=n&&n.jquery?n[0]:n,this.options.modifiers={},Object.keys(_extends({},e.Defaults.modifiers,o.modifiers)).forEach((function(t){r.options.modifiers[t]=_extends({},e.Defaults.modifiers[t]||{},o.modifiers?o.modifiers[t]:{})})),this.modifiers=Object.keys(this.options.modifiers).map((function(e){return _extends({name:e},r.options.modifiers[e])})).sort((function(e,t){return e.order-t.order})),this.modifiers.forEach((function(e){e.enabled&&isFunction(e.onLoad)&&e.onLoad(r.reference,r.popper,r.options,e,r.state)})),this.update();var i=this.options.eventsEnabled;i&&this.enableEventListeners(),this.state.eventsEnabled=i}return createClass(e,[{key:"update",value:function(){return update.call(this)}},{key:"destroy",value:function(){return destroy.call(this)}},{key:"enableEventListeners",value:function(){return enableEventListeners.call(this)}},{key:"disableEventListeners",value:function(){return disableEventListeners.call(this)}}]),e}();Popper.Utils=("undefined"!=typeof window?window:global).PopperUtils,Popper.placements=placements,Popper.Defaults=Defaults;export default Popper;