<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\MenuItem;

class MenuItemSeeder extends Seeder{

    public array $menuItems = [
        [
            "restaurant_id"  => 2,
            "cuisine_id"     => null,
            "name"           => "Cherry Pepsi®",
            "slug"           => "cherry-pepsi",
            "description"    => "<p>A refreshing twist on the classic cola, infused with the sweet and bold flavor of ripe cherries.</p>",
            "unit_price"     => "6.50",
            "discount_price" => "0.00",
            "counter"        => 2,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 3,
            "menu_number"    => 5449,
        ],
        [
            "restaurant_id"  => 2,
            "cuisine_id"     => null,
            "name"           => "MTN DEW® Baja Blast® Freeze",
            "slug"           => "mtn-dew-baja-blast-freeze",
            "description"    => "<p>A refreshing twist on the classic cola, infused with the sweet and bold flavor of ripe cherries.</p>",
            "unit_price"     => "6.50",
            "discount_price" => "0.00",
            "counter"        => 2,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 3,
            "menu_number"    => 6560,
        ],
        [
            "restaurant_id"  => 2,
            "cuisine_id"     => null,
            "name"           => "Pintos N Cheese",
            "slug"           => "pintos-n-cheese",
            "description"    => "<p>A refreshing twist on the classic cola, infused with the sweet and bold flavor of ripe cherries.</p>",
            "unit_price"     => "5.20",
            "discount_price" => "0.00",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 4976,
        ],
        [
            "restaurant_id"  => 2,
            "cuisine_id"     => null,
            "name"           => "Guacamole",
            "slug"           => "guacamole",
            "description"    => "<p>A refreshing twist on the classic cola, infused with the sweet and bold flavor of ripe cherries.</p>",
            "unit_price"     => "6.50",
            "discount_price" => "0.00",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 6383,
        ],
        [
            "restaurant_id"  => 2,
            "cuisine_id"     => null,
            "name"           => "Nacho Fries",
            "slug"           => "nacho-fries",
            "description"    => "<p>A refreshing twist on the classic cola, infused with the sweet and bold flavor of ripe cherries.</p>",
            "unit_price"     => "5.50",
            "discount_price" => "0.00",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 2208,
        ],
        [
            "restaurant_id"  => 2,
            "cuisine_id"     => null,
            "name"           => "Cheesy Fiesta Potatoes",
            "slug"           => "cheesy-fiesta-potatoes",
            "description"    => "<p>A refreshing twist on the classic cola, infused with the sweet and bold flavor of ripe cherries.</p>",
            "unit_price"     => "5.50",
            "discount_price" => "0.00",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 1037,
        ],
        [
            "restaurant_id"  => 2,
            "cuisine_id"     => null,
            "name"           => "Creamy Cheese Burger",
            "slug"           => "creamy-cheese-burger",
            "description"    => null,
            "unit_price"     => "12.50",
            "discount_price" => "0.00",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 1809,
        ],
        [
            "restaurant_id"  => 2,
            "cuisine_id"     => null,
            "name"           => "Cinnabon Delights® 12 Pack",
            "slug"           => "cinnabon-delights-12-pack",
            "description"    => "<p>A refreshing twist on the classic cola, infused with the sweet and bold flavor of ripe cherries.</p>",
            "unit_price"     => "6.50",
            "discount_price" => "0.00",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 6581,
        ],
        [
            "restaurant_id"  => 2,
            "cuisine_id"     => null,
            "name"           => "Cinnabon Delights® 2 Pack",
            "slug"           => "cinnabon-delights-2-pack",
            "description"    => "<p>A refreshing twist on the classic cola, infused with the sweet and bold flavor of ripe cherries.</p>",
            "unit_price"     => "10.00",
            "discount_price" => "0.00",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 1767,
        ],
        [
            "restaurant_id"  => 2,
            "cuisine_id"     => null,
            "name"           => "Big King",
            "slug"           => "big-king",
            "description"    => "<p>Double Patty with cheese and big king sause.</p>",
            "unit_price"     => "10.00",
            "discount_price" => "8.00",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 5739,
        ],
        [
            "restaurant_id"  => 2,
            "cuisine_id"     => null,
            "name"           => "Classic Combo",
            "slug"           => "classic-combo",
            "description"    => "<p>A refreshing twist on the classic cola, infused with the sweet and bold flavor of ripe cherries.</p>",
            "unit_price"     => "3.60",
            "discount_price" => "0.00",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 4742,
        ],
        [
            "id"             => 12,
            "restaurant_id"  => 2,
            "cuisine_id"     => null,
            "name"           => "Beefy Melt Burrito",
            "slug"           => "beefy-melt-burrito",
            "description"    => "<p>A refreshing twist on the classic cola, infused with the sweet and bold flavor of ripe cherries.</p>",
            "unit_price"     => "6.50",
            "discount_price" => "0.00",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 5726,
        ],
        [
            "restaurant_id"  => 2,
            "cuisine_id"     => null,
            "name"           => "Whopper",
            "slug"           => "whopper",
            "description"    => "Best burger, big patty, bun , lettuce, cheese.&nbsp;",
            "unit_price"     => "12.00",
            "discount_price" => "0.00",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 6056,
        ],
        [
            "restaurant_id"  => 5,
            "cuisine_id"     => null,
            "name"           => "Crispy Chicken",
            "slug"           => "crispy-chicken",
            "description"    => "<p>A refreshing twist on the classic cola, infused with the sweet and bold flavor of ripe cherries.</p>",
            "unit_price"     => "10.00",
            "discount_price" => "0.00",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 5888,
        ],
        [
            "restaurant_id"  => 2,
            "cuisine_id"     => null,
            "name"           => "Smashed Potatoes",
            "slug"           => "smashed-potatoes",
            "description"    => "<p>A refreshing twist on the classic cola, infused with the sweet and bold flavor of ripe cherries.</p>",
            "unit_price"     => "2.50",
            "discount_price" => "0.00",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 9883,
        ],
        [
            "restaurant_id"  => 5,
            "cuisine_id"     => null,
            "name"           => "Long Chicken",
            "slug"           => "long-chicken",
            "description"    => "Indulge in the comforting and wholesome experience of restful foods. Savor delicious classics prepared with a touch of warmth and care.",
            "unit_price"     => "9.00",
            "discount_price" => "0.00",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 2823,
        ],
        [
            "restaurant_id"  => 5,
            "cuisine_id"     => null,
            "name"           => "Creamy Cheese Burger",
            "slug"           => "creamy-cheese-burger-1",
            "description"    => "From fluffy pancakes to hearty omelets, each dish reflects the essence of home, inviting you to start your day.",
            "unit_price"     => "8.50",
            "discount_price" => "0.00",
            "counter"        => 1,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 3,
            "menu_number"    => 1121,
        ],
        [
            "restaurant_id"  => 2,
            "cuisine_id"     => null,
            "name"           => "The Big Burger",
            "slug"           => "the-big-burger",
            "description"    => "<p>A refreshing twist on the classic cola, infused with the sweet and bold flavor of ripe cherries.</p>",
            "unit_price"     => "5.00",
            "discount_price" => "0.75",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 2402,
        ],
        [
            "restaurant_id"  => 1,
            "cuisine_id"     => null,
            "name"           => "Gourmet Garlic Infusion Burger",
            "slug"           => "gourmet-garlic-infusion-burger",
            "description"    => "Juicy, char-grilled steak, adorned with a zesty chimichurri sauce, served alongside golden parmesan-crusted asparagus spears&nbsp;",
            "unit_price"     => "30.00",
            "discount_price" => "10.00",
            "counter"        => 7,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 3,
            "menu_number"    => 1656,
        ],
        [
            "restaurant_id"  => 5,
            "cuisine_id"     => null,
            "name"           => "Barbecue Chicken Burger",
            "slug"           => "barbecue-chicken-burger",
            "description"    => "<p>A taste sensation awaits!<br></p>",
            "unit_price"     => "10.00",
            "discount_price" => "0.50",
            "counter"        => 1,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 3,
            "menu_number"    => 5448,
        ],
        [
            "restaurant_id"  => 3,
            "cuisine_id"     => null,
            "name"           => "Peppermint Mocha",
            "slug"           => "peppermint-mocha",
            "description"    => "<p>A refreshing twist on the classic cola, infused with the sweet and bold flavor of ripe cherries.</p>",
            "unit_price"     => "6.50",
            "discount_price" => "0.00",
            "counter"        => 3,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 3,
            "menu_number"    => 7379,
        ],
        [
            "restaurant_id"  => 3,
            "cuisine_id"     => null,
            "name"           => "Caffè Americano",
            "slug"           => "caffe-americano",
            "description"    => "<p>A refreshing twist on the classic cola, infused with the sweet and bold flavor of ripe cherries.</p>",
            "unit_price"     => "5.50",
            "discount_price" => "0.00",
            "counter"        => 1,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 3,
            "menu_number"    => 8051,
        ],
        [
            "restaurant_id"  => 1,
            "cuisine_id"     => null,
            "name"           => "Smokin' BBQ Delight Burger",
            "slug"           => "smokin-bbq-delight-burger",
            "description"    => "A burger is a handheld delight, featuring a seasoned patty nestled in a bun with a variety of toppings, offering a flavorful and convenient culinary experience.",
            "unit_price"     => "35.00",
            "discount_price" => "2.00",
            "counter"        => 1,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 3,
            "menu_number"    => 8030,
        ],
        [
            "restaurant_id"  => 3,
            "cuisine_id"     => null,
            "name"           => "Cappuccino",
            "slug"           => "cappuccino",
            "description"    => "<p>A refreshing twist on the classic cola, infused with the sweet and bold flavor of ripe cherries.</p>",
            "unit_price"     => "6.15",
            "discount_price" => "0.00",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 7154,
        ],
        [
            "restaurant_id"  => 3,
            "cuisine_id"     => null,
            "name"           => "Caramel Brulée Latte",
            "slug"           => "caramel-brulee-latte",
            "description"    => "<p>A refreshing twist on the classic cola, infused with the sweet and bold flavor of ripe cherries.</p>",
            "unit_price"     => "10.50",
            "discount_price" => "0.00",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 9143,
        ],
        [
            "restaurant_id"  => 3,
            "cuisine_id"     => null,
            "name"           => "Caramel Apple Spice",
            "slug"           => "caramel-apple-spice",
            "description"    => "<p>A refreshing twist on the classic cola, infused with the sweet and bold flavor of ripe cherries.</p>",
            "unit_price"     => "5.15",
            "discount_price" => "0.00",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 2525,
        ],
        [
            "restaurant_id"  => 3,
            "cuisine_id"     => null,
            "name"           => "Mango Dragonfruit Lemonade Starbucks Refreshers® Beverage",
            "slug"           => "mango-dragonfruit-lemonade-starbucks-refreshers-beverage",
            "description"    => "<p>A refreshing twist on the classic cola, infused with the sweet and bold flavor of ripe cherries.</p>",
            "unit_price"     => "15.00",
            "discount_price" => "0.00",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 7387,
        ],
        [
            "restaurant_id"  => 8,
            "cuisine_id"     => null,
            "name"           => "Garden Harvest Salad",
            "slug"           => "garden-harvest-salad",
            "description"    => "<p>A refreshing twist on the classic cola, infused with the sweet and bold flavor of ripe cherries.</p>",
            "unit_price"     => "7.50",
            "discount_price" => "0.00",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 9417,
        ],
        [
            "restaurant_id"  => 5,
            "cuisine_id"     => null,
            "name"           => "Ginger burger",
            "slug"           => "ginger-burger",
            "description"    => "Indulge in the comforting and wholesome experience of restful foods.",
            "unit_price"     => "8.00",
            "discount_price" => "0.00",
            "counter"        => 1,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 3,
            "menu_number"    => 7632,
        ],
        [
            "restaurant_id"  => 3,
            "cuisine_id"     => null,
            "name"           => "Pink Drink Starbucks Refreshers® Beverage",
            "slug"           => "pink-drink-starbucks-refreshers-beverage",
            "description"    => "<p>A refreshing twist on the classic cola, infused with the sweet and bold flavor of ripe cherries.</p>",
            "unit_price"     => "15.50",
            "discount_price" => "0.00",
            "counter"        => 1,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 3,
            "menu_number"    => 4162,
        ],
        [
            "restaurant_id"  => 8,
            "cuisine_id"     => null,
            "name"           => "Mixed Greens Medley",
            "slug"           => "mixed-greens-medley",
            "description"    => "<p>A refreshing twist on the classic cola, infused with the sweet and bold flavor of ripe cherries.</p>",
            "unit_price"     => "5.50",
            "discount_price" => "0.00",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 2710,
        ],
        [
            "restaurant_id"  => 1,
            "cuisine_id"     => null,
            "name"           => "Sweet Heat Fiesta Burger",
            "slug"           => "sweet-heat-fiesta-burger",
            "description"    => "A burger is a handheld delight, featuring a seasoned patty nestled in a bun with a variety of toppings, offering a flavorful and convenient culinary experience.",
            "unit_price"     => "40.00",
            "discount_price" => "30.00",
            "counter"        => 2,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 4,
            "menu_number"    => 6522,
        ],
        [
            "restaurant_id"  => 3,
            "cuisine_id"     => null,
            "name"           => "Iced Matcha Lemonade",
            "slug"           => "iced-matcha-lemonade",
            "description"    => "<p>A refreshing twist on the classic cola, infused with the sweet and bold flavor of ripe cherries.</p>",
            "unit_price"     => "9.00",
            "discount_price" => "0.00",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 7259,
        ],
        [
            "restaurant_id"  => 5,
            "cuisine_id"     => null,
            "name"           => "Double cheese",
            "slug"           => "double-cheese",
            "description"    => "<p>From fluffy pancakes to hearty omelets, each dish reflects the essence of home, inviting you to start your day with familiar flavors and a sense of culinary  ▶",
            "unit_price"     => "8.75",
            "discount_price" => "1.00",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 9932,
        ],
        [
            "restaurant_id"  => 3,
            "cuisine_id"     => null,
            "name"           => "Iced Passion Tango® Tea Lemonade",
            "slug"           => "iced-passion-tango-tea-lemonade",
            "description"    => "<p>A refreshing twist on the classic cola, infused with the sweet and bold flavor of ripe cherries.</p>",
            "unit_price"     => "5.00",
            "discount_price" => "0.00",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 7521,
        ],
        [
            "restaurant_id"  => 8,
            "cuisine_id"     => null,
            "name"           => "Quinoa and Roasted Veggie Bowl",
            "slug"           => "quinoa-and-roasted-veggie-bowl",
            "description"    => "<p>A refreshing twist on the classic cola, infused with the sweet and bold flavor of ripe cherries.</p>",
            "unit_price"     => "3.99",
            "discount_price" => "0.00",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 8778,
        ],
        [
            "restaurant_id"  => 8,
            "cuisine_id"     => null,
            "name"           => "Harvest Chicken Salad",
            "slug"           => "harvest-chicken-salad",
            "description"    => "<p>A refreshing twist on the classic cola, infused with the sweet and bold flavor of ripe cherries.</p>",
            "unit_price"     => "5.50",
            "discount_price" => "0.00",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 9357,
        ],
        [
            "restaurant_id"  => 5,
            "cuisine_id"     => null,
            "name"           => "Big King",
            "slug"           => "big-king-1",
            "description"    => "From fluffy pancakes to hearty omelets, each dish reflects the essence of home.",
            "unit_price"     => "10.00",
            "discount_price" => "0.50",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 5359,
        ],
        [
            "restaurant_id"  => 5,
            "cuisine_id"     => null,
            "name"           => "Beef burger",
            "slug"           => "beef-burger",
            "description"    => "Indulge in the comforting and wholesome experience of restful foods.",
            "unit_price"     => "7.00",
            "discount_price" => "0.00",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 7442,
        ],
        [
            "restaurant_id"  => 3,
            "cuisine_id"     => null,
            "name"           => "Caramel Apple Spice",
            "slug"           => "caramel-apple-spice-1",
            "description"    => "<p>A refreshing twist on the classic cola, infused with the sweet and bold flavor of ripe cherries.</p>",
            "unit_price"     => "6.00",
            "discount_price" => "0.00",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 2564,
        ],
        [
            "restaurant_id"  => 8,
            "cuisine_id"     => null,
            "name"           => "Caprese Salad",
            "slug"           => "caprese-salad",
            "description"    => "<p>A refreshing twist on the classic cola, infused with the sweet and bold flavor of ripe cherries.</p>",
            "unit_price"     => "5.99",
            "discount_price" => "0.00",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 1413,
        ],
        [
            "restaurant_id"  => 1,
            "cuisine_id"     => null,
            "name"           => "Aloha Teriyaki Twist Burger",
            "slug"           => "aloha-teriyaki-twist-burger",
            "description"    => "<p>A burger is a handheld delight, featuring a seasoned patty nestled in a bun with a variety of toppings, offering a flavorful and convenient culinary experien ▶",
            "unit_price"     => "33.00",
            "discount_price" => "0.00",
            "counter"        => 1,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 3,
            "menu_number"    => 9863,
        ],
        [
            "restaurant_id"  => 8,
            "cuisine_id"     => null,
            "name"           => "Greek Village Salad",
            "slug"           => "greek-village-salad",
            "description"    => "<p>A refreshing twist on the classic cola, infused with the sweet and bold flavor of ripe cherries.</p>",
            "unit_price"     => "7.00",
            "discount_price" => "2.01",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 9651,
        ],
        [
            "restaurant_id"  => 5,
            "cuisine_id"     => null,
            "name"           => "Naga burger",
            "slug"           => "naga-burger",
            "description"    => null,
            "unit_price"     => "8.75",
            "discount_price" => "0.00",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 6644,
        ],
        [
            "restaurant_id"  => 5,
            "cuisine_id"     => null,
            "name"           => "Chicker burger",
            "slug"           => "chicker-burger",
            "description"    => null,
            "unit_price"     => "9.00",
            "discount_price" => "0.00",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 8122,
        ],
        [
            "restaurant_id"  => 8,
            "cuisine_id"     => null,
            "name"           => "Southwest Chipotle Chicken Salad",
            "slug"           => "southwest-chipotle-chicken-salad",
            "description"    => "<p>A refreshing twist on the classic cola, infused with the sweet and bold flavor of ripe cherries.</p>",
            "unit_price"     => "3.99",
            "discount_price" => "0.00",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 6927,
        ],
        [
            "restaurant_id"  => 8,
            "cuisine_id"     => null,
            "name"           => "Asian Sesame Tofu Bowl",
            "slug"           => "asian-sesame-tofu-bowl",
            "description"    => "<p>A refreshing twist on the classic cola, infused with the sweet and bold flavor of ripe cherries.</p>",
            "unit_price"     => "6.99",
            "discount_price" => "0.00",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 5123,
        ],
        [
            "restaurant_id"  => 1,
            "cuisine_id"     => null,
            "name"           => "Royal Saffron Delight Biryani",
            "slug"           => "royal-saffron-delight-biryani",
            "description"    => "A delightful fusion of fragrant rice, tender meat, and aromatic spices, creating a symphony of flavors in just one dish. A culinary masterpiece cherished across ▶",
            "unit_price"     => "30.00",
            "discount_price" => "0.00",
            "counter"        => 4,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 3,
            "menu_number"    => 1308,
        ],
        [
            "restaurant_id"  => 8,
            "cuisine_id"     => null,
            "name"           => "Salmon Superfood Bowl",
            "slug"           => "salmon-superfood-bowl",
            "description"    => "<p>A refreshing twist on the classic cola, infused with the sweet and bold flavor of ripe cherries.</p>",
            "unit_price"     => "12.99",
            "discount_price" => "3.99",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 7225,
        ],
        [
            "restaurant_id"  => 1,
            "cuisine_id"     => null,
            "name"           => "Nawabi Lamb Galore Biryani",
            "slug"           => "nawabi-lamb-galore-biryani",
            "description"    => null,
            "unit_price"     => "90.00",
            "discount_price" => "0.00",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 5284,
        ],
        [
            "restaurant_id"  => 8,
            "cuisine_id"     => null,
            "name"           => "Protein-Packed Lentil Salad",
            "slug"           => "protein-packed-lentil-salad",
            "description"    => "<p>A refreshing twist on the classic cola, infused with the sweet and bold flavor of ripe cherries.</p>",
            "unit_price"     => "6.99",
            "discount_price" => "0.00",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 6471,
        ],
        [
            "restaurant_id"  => 8,
            "cuisine_id"     => null,
            "name"           => "Falafel and Hummus Plate",
            "slug"           => "falafel-and-hummus-plate",
            "description"    => "<p>A refreshing twist on the classic cola, infused with the sweet and bold flavor of ripe cherries.</p>",
            "unit_price"     => "6.50",
            "discount_price" => "0.00",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 1069,
        ],
        [
            "restaurant_id"  => 1,
            "cuisine_id"     => null,
            "name"           => "Saffron Gulab Jamun.",
            "slug"           => "saffron-gulab-jamun",
            "description"    => "Sweets, with their indulgent sweetness and myriad textures, transcend cultures, offering a delightful escape into the world of confectionery.&nbsp;",
            "unit_price"     => "85.00",
            "discount_price" => "75.00",
            "counter"        => 16,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 3,
            "menu_number"    => 3115,
        ],
        [
            "restaurant_id"  => 1,
            "cuisine_id"     => null,
            "name"           => "Gajar Ka Halwa",
            "slug"           => "gajar-ka-halwa",
            "description"    => "Sweets, with their indulgent sweetness and myriad textures, transcend cultures, offering a delightful escape into the world of confectionery.&nbsp;",
            "unit_price"     => "20.00",
            "discount_price" => "0.00",
            "counter"        => 4,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 3,
            "menu_number"    => 2794,
        ],
        [
            "restaurant_id"  => 8,
            "cuisine_id"     => null,
            "name"           => "Mediterranean Chickpea Salad",
            "slug"           => "mediterranean-chickpea-salad",
            "description"    => "<p>A refreshing twist on the classic cola, infused with the sweet and bold flavor of ripe cherries.</p>",
            "unit_price"     => "4.99",
            "discount_price" => "0.00",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 4470,
        ],
        [
            "restaurant_id"  => 7,
            "cuisine_id"     => null,
            "name"           => "Carne Asada Wham! Burrito",
            "slug"           => "carne-asada-wham-burrito",
            "description"    => "<p>A refreshing twist on the classic cola, infused with the sweet and bold flavor of ripe cherries.</p>",
            "unit_price"     => "6.15",
            "discount_price" => "0.00",
            "counter"        => 1,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 3,
            "menu_number"    => 5081,
        ],
        [
            "restaurant_id"  => 7,
            "cuisine_id"     => null,
            "name"           => "Barbacoa Wham! Burrito",
            "slug"           => "barbacoa-wham-burrito",
            "description"    => "<p>A refreshing twist on the classic cola, infused with the sweet and bold flavor of ripe cherries.</p>",
            "unit_price"     => "8.00",
            "discount_price" => "0.00",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 4243,
        ],
        [
            "restaurant_id"  => 6,
            "cuisine_id"     => null,
            "name"           => "White Sauce Pasta",
            "slug"           => "white-sauce-pasta",
            "description"    => null,
            "unit_price"     => "10.00",
            "discount_price" => "0.00",
            "counter"        => 1,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 3,
            "menu_number"    => 7933,
        ],
        [
            "restaurant_id"  => 7,
            "cuisine_id"     => null,
            "name"           => "Al Pastor Wham! Burrito",
            "slug"           => "al-pastor-wham-burrito",
            "description"    => "<p>A refreshing twist on the classic cola, infused with the sweet and bold flavor of ripe cherries.</p>",
            "unit_price"     => "10.50",
            "discount_price" => "0.00",
            "counter"        => 1,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 3,
            "menu_number"    => 4080,
        ],
        [
            "restaurant_id"  => 7,
            "cuisine_id"     => null,
            "name"           => "Barbacoa Wham! Burrito",
            "slug"           => "barbacoa-wham-burrito-1",
            "description"    => "<p>A refreshing twist on the classic cola, infused with the sweet and bold flavor of ripe cherries.</p>",
            "unit_price"     => "10.50",
            "discount_price" => "0.00",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 7864,
        ],
        [
            "restaurant_id"  => 6,
            "cuisine_id"     => null,
            "name"           => "Mashroom pasta",
            "slug"           => "mashroom-pasta",
            "description"    => null,
            "unit_price"     => "7.50",
            "discount_price" => "0.00",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 3003,
        ],
        [
            "restaurant_id"  => 4,
            "cuisine_id"     => null,
            "name"           => "Quarter Pounder with Cheese",
            "slug"           => "quarter-pounder-with-cheese",
            "description"    => "<p>A refreshing twist on the classic cola, infused with the sweet and bold flavor of ripe cherries.</p>",
            "unit_price"     => "5.99",
            "discount_price" => "0.00",
            "counter"        => 1,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 3,
            "menu_number"    => 6476,
        ],
        [
            "restaurant_id"  => 6,
            "cuisine_id"     => null,
            "name"           => "Red Sause Pasta",
            "slug"           => "red-sause-pasta",
            "description"    => "Indulge in the comforting and wholesome experience of restful foods.",
            "unit_price"     => "6.00",
            "discount_price" => "0.00",
            "counter"        => 1,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 3,
            "menu_number"    => 9390,
        ],
        [
            "restaurant_id"  => 7,
            "cuisine_id"     => null,
            "name"           => "Horchata",
            "slug"           => "horchata",
            "description"    => "<p>A refreshing twist on the classic cola, infused with the sweet and bold flavor of ripe cherries.</p>",
            "unit_price"     => "10.50",
            "discount_price" => "0.00",
            "counter"        => 1,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 3,
            "menu_number"    => 3257,
        ],
        [
            "restaurant_id"  => 6,
            "cuisine_id"     => null,
            "name"           => "Lemon pasta",
            "slug"           => "lemon-pasta",
            "description"    => "Savor the succulent delight of a perfectly made.",
            "unit_price"     => "7.00",
            "discount_price" => "0.00",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 7804,
        ],
        [
            "restaurant_id"  => 4,
            "cuisine_id"     => null,
            "name"           => "McChicken",
            "slug"           => "mcchicken",
            "description"    => "<p>A refreshing twist on the classic cola, infused with the sweet and bold flavor of ripe cherries.</p>",
            "unit_price"     => "8.00",
            "discount_price" => "0.00",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 9506,
        ],
        [
            "restaurant_id"  => 7,
            "cuisine_id"     => null,
            "name"           => "Lemonade",
            "slug"           => "lemonade",
            "description"    => "<p>A refreshing twist on the classic cola, infused with the sweet and bold flavor of ripe cherries.</p>",
            "unit_price"     => "2.50",
            "discount_price" => "0.00",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 3005,
        ],
        [
            "restaurant_id"  => 4,
            "cuisine_id"     => null,
            "name"           => "Spicy McChicken",
            "slug"           => "spicy-mcchicken",
            "description"    => "<p>A refreshing twist on the classic cola, infused with the sweet and bold flavor of ripe cherries.</p>",
            "unit_price"     => "6.60",
            "discount_price" => "0.00",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 3754,
        ],
        [
            "restaurant_id"  => 6,
            "cuisine_id"     => null,
            "name"           => "Indian Pasta",
            "slug"           => "indian-pasta",
            "description"    => "Indulge in the comforting and wholesome experience of restful foods.",
            "unit_price"     => "8.00",
            "discount_price" => "0.00",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 6013,
        ],
        [
            "restaurant_id"  => 4,
            "cuisine_id"     => null,
            "name"           => "Coca-Cola®",
            "slug"           => "coca-cola",
            "description"    => "<p>A refreshing twist on the classic cola, infused with the sweet and bold flavor of ripe cherries.</p>",
            "unit_price"     => "1.29",
            "discount_price" => "0.00",
            "counter"        => 1,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 3,
            "menu_number"    => 4950,
        ],
        [
            "restaurant_id"  => 4,
            "cuisine_id"     => null,
            "name"           => "McCafé® Caramel Frappé",
            "slug"           => "mccafe-caramel-frappe",
            "description"    => "<p>A refreshing twist on the classic cola, infused with the sweet and bold flavor of ripe cherries.</p>",
            "unit_price"     => "2.99",
            "discount_price" => "0.00",
            "counter"        => 1,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 3,
            "menu_number"    => 7818,
        ],
        [
            "restaurant_id"  => 6,
            "cuisine_id"     => null,
            "name"           => "Smokey pasta",
            "slug"           => "smokey-pasta",
            "description"    => "Indulge in the comforting and wholesome experience of restful foods. Savor delicious classics prepared with a touch of warmth and care.",
            "unit_price"     => "10.00",
            "discount_price" => "0.00",
            "counter"        => 1,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 3,
            "menu_number"    => 5375,
        ],
        [
            "restaurant_id"  => 6,
            "cuisine_id"     => null,
            "name"           => "Chili peeper",
            "slug"           => "chili-peeper",
            "description"    => "From fluffy pancakes to hearty omelets, each dish reflects the essence of home, inviting you to start your day with familiar flavors and a sense of culinary nos ▶",
            "unit_price"     => "10.00",
            "discount_price" => "0.00",
            "counter"        => 1,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 3,
            "menu_number"    => 8372,
        ],
        [
            "restaurant_id"  => 4,
            "cuisine_id"     => null,
            "name"           => "McFlurry",
            "slug"           => "mcflurry",
            "description"    => "<p>A refreshing twist on the classic cola, infused with the sweet and bold flavor of ripe cherries.</p>",
            "unit_price"     => "9.99",
            "discount_price" => "0.00",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 5189,
        ],
        [
            "restaurant_id"  => 4,
            "cuisine_id"     => null,
            "name"           => "Apple Pie",
            "slug"           => "apple-pie",
            "description"    => "<p>A refreshing twist on the classic cola, infused with the sweet and bold flavor of ripe cherries.</p>",
            "unit_price"     => "7.00",
            "discount_price" => "1.01",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 7285,
        ],
        [
            "restaurant_id"  => 4,
            "cuisine_id"     => null,
            "name"           => "McDouble Delight",
            "slug"           => "mcdouble-delight",
            "description"    => "<p>A refreshing twist on the classic cola, infused with the sweet and bold flavor of ripe cherries.</p>",
            "unit_price"     => "3.00",
            "discount_price" => "0.00",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 3476,
        ],
        [
            "restaurant_id"  => 4,
            "cuisine_id"     => null,
            "name"           => "Grilled Chicken Supreme",
            "slug"           => "grilled-chicken-supreme",
            "description"    => "<p>A refreshing twist on the classic cola, infused with the sweet and bold flavor of ripe cherries.</p>",
            "unit_price"     => "5.99",
            "discount_price" => "0.00",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 7872,
        ],
        [
            "restaurant_id"  => 6,
            "cuisine_id"     => null,
            "name"           => "Chicken pasta",
            "slug"           => "chicken-pasta",
            "description"    => "Indulge in the comforting and wholesome experience of restful foods.",
            "unit_price"     => "10.00",
            "discount_price" => "0.00",
            "counter"        => 0,
            "status"         => 5,
            "tags"           => null,
            "order"          => 1,
            "creator_type"   => "App\Models\User",
            "creator_id"     => 1,
            "editor_type"    => "App\Models\User",
            "editor_id"      => 1,
            "menu_number"    => 1969,
        ],

    ];

    /**
     * Run the database seeds.
     */
     public function run(){
        if (env('DEMO_MODE')) {
            foreach ($this->menuItems as $menuItem) {
                $menuItemObject = MenuItem::create([
                    'restaurant_id'  => $menuItem['restaurant_id'],
                    'cuisine_id'     => $menuItem['cuisine_id'],
                    'name'           => $menuItem['name'],
                    'slug'           => $menuItem['slug'],
                    'description'    => $menuItem['description'],
                    'unit_price'     => $menuItem['unit_price'],
                    'discount_price' => $menuItem['discount_price'],
                    'counter'        => $menuItem['counter'],
                    'status'         => $menuItem['status'],
                    'tags'           => $menuItem['tags'],
                    'order'          => $menuItem['order'],
                    'creator_type'   => $menuItem['creator_type'],
                    'creator_id'     => $menuItem['creator_id'],
                    'editor_type'    => $menuItem['editor_type'],
                    'editor_id'      => $menuItem['editor_id'],
                    'menu_number'    => $menuItem['menu_number'],
                ]);
                if (file_exists(
                    public_path('/images/seeder/menu-item/' . $menuItem['slug'].'.jpg')
                )) {
                    $menuItemObject->addMedia(
                        public_path('/images/seeder/menu-item/' .  $menuItem['slug'].'.jpg')
                    )->preservingOriginal()->toMediaCollection('menu-items');
                }
            }
        }
    }
}
