<?php

namespace Database\Seeders;

use App\Models\Category;
use Illuminate\Database\Seeder;
use App\Enums\Status;

class CategoryTableSeeder extends Seeder
{
    public array $categories = [
        [
            "name"         => "Sweets",
            "slug"         => "sweets",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Cravings Value Menu",
            "slug"         => "cravings-value-menu",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Nachos",
            "slug"         => "nachos",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Burritos",
            "slug"         => "burritos",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Tacos",
            "slug"         => "tacos",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Specialties",
            "slug"         => "specialties",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Sauce Packets",
            "slug"         => "sauce-packets",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Featured",
            "slug"         => "featured",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "The Desert God",
            "slug"         => "the-desert-god",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "The Salad God",
            "slug"         => "the-salad-god",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Bam! Snacks",
            "slug"         => "bam-snacks",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Wham! Bam! Favorites",
            "slug"         => "wham-bam-favorites",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Wham! Bam! Burritos",
            "slug"         => "wham-bam-burritos",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Milkshake",
            "slug"         => "milkshake",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Bowl",
            "slug"         => "bowl",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Gourmet Wraps",
            "slug"         => "gourmet-wraps",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Impossible™ Burgers",
            "slug"         => "impossible-burgers",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Impossible™ BurgersDessert",
            "slug"         => "impossible-burgersdessert",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Sandwiches",
            "slug"         => "sandwiches",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Burgers",
            "slug"         => "burgers",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Combos",
            "slug"         => "combos",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Primo Pastas",
            "slug"         => "primo-pastas",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Drinks",
            "slug"         => "drinks",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Sides",
            "slug"         => "sides",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Insalata Italiana (Salads)",
            "slug"         => "insalata-italiana-salads",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Small Bites To Go",
            "slug"         => "small-bites-to-go",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "The Cakes",
            "slug"         => "the-cakes",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "The Exotic Juices",
            "slug"         => "the-exotic-juices",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "The Exotic Smoothies",
            "slug"         => "the-exotic-smoothies",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Beverages",
            "slug"         => "beverages",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Condiments",
            "slug"         => "condiments",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Iced Teas",
            "slug"         => "iced-teas",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Cold Drinks",
            "slug"         => "cold-drinks",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Cold Coffees",
            "slug"         => "cold-Coffees",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Hot Drinks",
            "slug"         => "hot-drinks",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Hot Coffees",
            "slug"         => "hot-coffees",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "McCafé Bakery",
            "slug"         => "mccafe-bakery",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Hash Browns and Sides",
            "slug"         => "hash-browns-and-sides",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Combo Meals",
            "slug"         => "combo-meals",
            "description"  => "<p>Indulge in the comforting and wholesome experience of restful foods. Savor delicious classics prepared with a touch of warmth and care. From fluffy pancakes  ▶",
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Desserts",
            "slug"         => "desserts",
            "description"  => "<p>Indulge in the comforting and wholesome experience of restful foods. Savor delicious classics prepared with a touch of warmth and care. From fluffy pancakes  ▶",
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name" => "Family Bundles",
            "slug" => "family-bundles",
            "description" => "<p>Awaken your taste buds with a delightful morning feast. This offer a symphony of flavors, from delectable pancakes to savory omelets, crafted with a dash of  ▶",
            "depth" => 0,
            "left" => 0,
            "right" => 0,
            "parent_id" => 0,
            "status" => 5,
            "requested" => 5,
            "creator_type" => "App\Models\User",
            "creator_id" => 1,
            "editor_type" => "App\Models\User",
            "editor_id" => 1,
        ],
        [
            "name"         => "A La Carte (pm)",
            "slug"         => "a-la-carte-pm",
            "description"  => "<p>Awaken your taste buds with a delightful morning feast. This offer a symphony of flavors, from delectable pancakes to savory omelets, crafted with a dash of  ▶",
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Meals (pm)",
            "slug"         => "meals-pm",
            "description"  => "<p>Indulge in the comforting and wholesome experience of restful foods. Savor delicious classics prepared with a touch of warmth and care. From fluffy pancakes  ▶",
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Homestyle Breakfasts",
            "slug"         => "homestyle-breakfasts",
            "description"  => "<p>Indulge in the comforting and wholesome experience of restful foods. Savor delicious classics prepared with a touch of warmth and care. From fluffy pancakes  ▶",
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Fresh Garden Greens",
            "slug"         => "fresh-garden-greens",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Wholesome Harvest Bowls",
            "slug"         => "wholesome-harvest-bowls",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Vibrant Veggie Delights",
            "slug"         => "vibrant-veggie-delights",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Nutrient-Packed Power Bowls",
            "slug"         => "nutrient-packed-power-bowls",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Chicken",
            "slug"         => "chicken",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Salad",
            "slug"         => "salad",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Sweets",
            "slug"         => "sweets-1",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Cravings Value Menu",
            "slug"         => "cravings-value-menu-1",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Nachos",
            "slug"         => "nachos-1",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Burritos",
            "slug"         => "burritos-1",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Tacos",
            "slug"         => "tacos-1",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Specialties",
            "slug"         => "specialties-1",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Sauce Packets",
            "slug"         => "sauce-packets-1",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Featured",
            "slug"         => "featured-1",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "The Desert God",
            "slug"         => "the-desert-god-1",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "The Salad God",
            "slug"         => "the-salad-god-1",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Bam! Snacks",
            "slug"         => "bam-snacks-1",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Wham! Bam! Favorites",
            "slug"         => "wham-bam-favorites-1",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Wham! Bam! Burritos",
            "slug"         => "wham-bam-burritos-1",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Milkshake",
            "slug"         => "milkshake-1",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],
        [
            "name"         => "Bowl",
            "slug"         => "bowl-1",
            "description"  => null,
            "depth"        => 0,
            "left"         => 0,
            "right"        => 0,
            "parent_id"    => 0,
            "status"       => 5,
            "requested"    => 5,
            "creator_type" => "App\Models\User",
            "creator_id"   => 1,
            "editor_type"  => "App\Models\User",
            "editor_id"    => 1,
        ],

    ];

    public function run(){
        if (env('DEMO_MODE')) {
            foreach ($this->categories as $category) {
                $categoryObject = Category::create([
                    'name'         => $category['name'],
                    'slug'         => $category['slug'],
                    'description'  => $category['description'],
                    'depth'        => $category['depth'],
                    'left'         => $category['left'],
                    'right'        => $category['right'],
                    'parent_id'    => $category['parent_id'],
                    'status'       => $category['status'],
                    'requested'    => $category['requested'],
                    'creator_type' => $category['creator_type'],
                    'creator_id'   => $category['creator_id'],
                    'editor_type'  => $category['editor_type'],
                    'editor_id'    => $category['editor_id'],
                ]);

                if (file_exists(
                    public_path('/images/seeder/category/category.png')
                )) {
                    $categoryObject->addMedia(
                        public_path('/images/seeder/category/category.png')
                    )->preservingOriginal()->toMediaCollection('categories');
                }
            }
        }
    }
}
